<?php
header('Content-Type: application/xml; charset=utf-8');

define('SITES_PER_PAGE', 100);
define('DATA_DIR', __DIR__ . '/data');
define('CACHE_FILE', DATA_DIR . '/domains_cache.txt');
define('MALICIOUS_FILE', DATA_DIR . '/malicious.txt');
define('USER_SITES_FILE', DATA_DIR . '/user_sites.txt');
define('DOMAIN_LIST_URL', 'https://websitedesing.com.tr/tr/turkish.txt');

function loadDomains() {
    if (file_exists(CACHE_FILE) && (time() - filemtime(CACHE_FILE) < 86400)) {
        $content = file_get_contents(CACHE_FILE);
        return array_filter(explode("\n", $content));
    }
    
    $content = @file_get_contents(DOMAIN_LIST_URL);
    if ($content) {
        if (!file_exists(DATA_DIR)) {
            mkdir(DATA_DIR, 0755, true);
        }
        file_put_contents(CACHE_FILE, $content);
        return array_filter(explode("\n", $content));
    }
    
    return [];
}

function loadUserSites() {
    if (!file_exists(USER_SITES_FILE)) {
        return [];
    }
    return array_filter(file(USER_SITES_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES));
}

function loadMaliciousSites() {
    if (!file_exists(MALICIOUS_FILE)) {
        return [];
    }
    return array_filter(file(MALICIOUS_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES));
}

$all_domains = array_merge(loadDomains(), loadUserSites());
$malicious = loadMaliciousSites();
$all_domains = array_diff($all_domains, $malicious);

$total_sites = count($all_domains);
$total_pages = ceil($total_sites / SITES_PER_PAGE);

echo '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
    <url>
        <loc>https://iyisiteler.websitedesing.com.tr/</loc>
        <changefreq>daily</changefreq>
        <priority>1.0</priority>
    </url>
    <?php for ($i = 1; $i <= min($total_pages, 1000); $i++): ?>
    <url>
        <loc>https://iyisiteler.websitedesing.com.tr/?page=<?php echo $i; ?></loc>
        <changefreq>daily</changefreq>
        <priority>0.8</priority>
    </url>
    <?php endfor; ?>
</urlset>
