<?php
session_start();
error_reporting(0);

define('DATA_DIR', __DIR__ . '/data');
define('VOTES_FILE', DATA_DIR . '/votes.txt');
define('MALICIOUS_FILE', DATA_DIR . '/malicious.txt');
define('IP_VOTES_FILE', DATA_DIR . '/ip_votes.txt');
define('BANNED_IPS_FILE', DATA_DIR . '/banned_ips.txt');

require_once 'functions.php';
require_once 'languages.php';

$domain = $_GET['domain'] ?? '';
if (!$domain) { header('Location: index.php'); exit; }

$client_ip = getClientIP();
if (isIPBanned($client_ip)) die($t['access_denied'] ?? 'Erişim Engellendi');

if (isset($_POST['add_comment'])) {
    $user_name = $_SESSION['user']['name'] ?? 'Misafir_' . substr(md5($client_ip), 0, 5);
    $comment_text = $_POST['comment_text'];
    if (saveComment($domain, $user_name, $client_ip, $comment_text)) {
        $_SESSION['success'] = 'Yorum eklendi!';
    } else {
        $_SESSION['error'] = 'Yorum limitine ulaştınız!';
    }
    header("Location: comments.php?domain=$domain"); exit;
}

$comments = loadComments($domain);
$descriptions = [];
if (file_exists(DATA_DIR . '/descriptions.txt')) {
    $lines = file(DATA_DIR . '/descriptions.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        $parts = explode('|', $line);
        if (count($parts) == 2) $descriptions[$parts[0]] = $parts[1];
    }
}
$description = $descriptions[$domain] ?? '';

// Tema Yönetimi
$current_theme = $_SESSION['theme'] ?? 'dark';
?>
<!DOCTYPE html>
<html lang="<?php echo $lang_code; ?>" data-theme="<?php echo $current_theme; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $domain; ?> - <?php echo $t['title']; ?></title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <header>
        <div class="container">
            <h1>🌟 <?php echo $domain; ?></h1>
            <nav>
                <a href="index.php"><?php echo $t['home']; ?></a>
                <a href="admin/"><?php echo $t['admin']; ?></a>
            </nav>
        </div>
    </header>

    <main class="container">
        <div class="site-card" style="margin-bottom: 30px;">
            <div class="site-info">
                <h2><?php echo $domain; ?></h2>
                <?php if($description): ?>
                    <p style="margin-top: 10px; color: var(--text); background: var(--bg); padding: 15px; border-radius: 8px; border-left: 4px solid var(--primary);">
                        <?php echo htmlspecialchars($description); ?>
                    </p>
                <?php endif; ?>
            </div>
        </div>

        <div class="add-site-section">
            <h3>Yorum Yap</h3>
            <?php if($_SESSION['success']): ?><div class="alert alert-success"><?php echo $_SESSION['success']; unset($_SESSION['success']); ?></div><?php endif; ?>
            <?php if($_SESSION['error']): ?><div class="alert alert-malicious" style="background:rgba(239,68,68,0.2); color:#f87171; padding:10px; border-radius:5px; margin-bottom:10px;"><?php echo $_SESSION['error']; unset($_SESSION['error']); ?></div><?php endif; ?>
            
            <form method="post" style="margin-top: 15px;">
                <textarea name="comment_text" style="width:100%; height:100px; background:var(--bg); color:var(--text); border:1px solid var(--border); border-radius:8px; padding:15px;" placeholder="Yorumunuzu yazın..." required></textarea>
                <button type="submit" name="add_comment" class="btn btn-primary" style="margin-top: 10px;">Gönder</button>
            </form>
        </div>

        <div class="sites-list" style="margin-top: 30px;">
            <h3>Yorumlar (<?php echo count($comments); ?>)</h3>
            <?php foreach($comments as $c): ?>
                <div class="site-card" style="flex-direction: column; align-items: flex-start; gap: 10px;">
                    <div style="display: flex; justify-content: space-between; width: 100%; font-size: 14px; color: var(--muted);">
                        <strong><?php echo htmlspecialchars($c['user']); ?></strong>
                        <span><?php echo date('d.m.Y H:i', $c['time']); ?></span>
                    </div>
                    <div style="color: var(--text);"><?php echo htmlspecialchars($c['text']); ?></div>
                </div>
            <?php endforeach; ?>
            <?php if(empty($comments)): ?>
                <p style="text-align: center; color: var(--muted); padding: 20px;">Henüz yorum yapılmamış.</p>
            <?php endif; ?>
        </div>
    </main>

    <footer>
        <div class="container">
            <p>Web Tasarım: <a href="https://proweb.net.tr">ProWeb.net.tr</a></p>
        </div>
    </footer>
</body>
</html>
