<?php
session_start();
error_reporting(0);

define('DATA_DIR', dirname(__DIR__) . '/data');
define('URLLER_DIR', dirname(__DIR__) . '/urller');
define('MALICIOUS_FILE', DATA_DIR . '/malicious.txt');
define('ADS_FILE', DATA_DIR . '/ads.txt');
define('CONFIG_FILE', DATA_DIR . '/config.txt');
define('USER_SITES_FILE', DATA_DIR . '/user_sites.txt');
define('IP_DOMAINS_FILE', DATA_DIR . '/ip_domains.txt');
define('BANNED_IPS_FILE', DATA_DIR . '/banned_ips.txt');
define('CACHE_FILE', DATA_DIR . '/domains_cache.txt');
define('VOTES_FILE', DATA_DIR . '/votes.txt');

require_once dirname(__DIR__) . '/functions.php';

function getAdminPassword() {
    if (file_exists(CONFIG_FILE)) {
        $config = file_get_contents(CONFIG_FILE);
        $lines = explode("\n", $config);
        foreach ($lines as $line) if (strpos($line, 'password=') === 0) return trim(substr($line, 9));
    }
    return 'admin123';
}

if (!isset($_SESSION['admin_logged_in'])) {
    if (isset($_POST['login'])) {
        $stored = getAdminPassword();
        $pass = $_POST['password'];
        if ((strpos($stored, '$') === 0 && password_verify($pass, $stored)) || $pass === $stored) {
            $_SESSION['admin_logged_in'] = true;
            header('Location: index.php'); exit;
        }
    }
    ?>
    <!DOCTYPE html><html><head><meta charset="UTF-8"><title>Admin Giriş</title><link rel="stylesheet" href="../style.css"></head>
    <body><div class="login-form"><h2>🔐 Yönetim Paneli</h2><form method="post"><input type="password" name="password" placeholder="Şifre" required><button type="submit" name="login" class="btn btn-primary">Giriş</button></form></div></body></html>
    <?php exit;
}

if (isset($_GET['logout'])) { session_destroy(); header('Location: index.php'); exit; }

$active_tab = $_GET['tab'] ?? 'stats';

if (isset($_POST['save_ads'])) {
    $ad_codes = array_filter(explode("---AD-SEPARATOR---", $_POST['ad_codes']));
    saveAds($ad_codes);
    $_SESSION['success'] = 'Reklamlar güncellendi!';
    header('Location: index.php?tab=ads'); exit;
}

if (isset($_POST['delete_malicious_bulk'])) {
    $count = deleteMaliciousSites($_POST['selected_malicious'] ?? []);
    $_SESSION['success'] = $count . ' site silindi!';
    header('Location: index.php?tab=malicious'); exit;
}

if (isset($_POST['ban_ip'])) {
    file_put_contents(BANNED_IPS_FILE, $_POST['ip'] . "\n", FILE_APPEND);
    $_SESSION['success'] = 'IP banlandı!';
    header('Location: index.php?tab=ips'); exit;
}

if (isset($_POST['unban_ip'])) {
    $banned = file(BANNED_IPS_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $new = array_diff($banned, [$_POST['ip']]);
    file_put_contents(BANNED_IPS_FILE, implode("\n", $new) . (empty($new) ? "" : "\n"));
    $_SESSION['success'] = 'IP banı kaldırıldı!';
    header('Location: index.php?tab=ips'); exit;
}

$stats = getStats();
$malicious_sites = loadMaliciousSites();
$ads = loadAds();
$local_files = array_diff(scandir(URLLER_DIR), array('.', '..', '.htaccess'));
$banned_ips = file_exists(BANNED_IPS_FILE) ? file(BANNED_IPS_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];

// IP İstatistikleri
$ip_stats = [];
if (file_exists(IP_DOMAINS_FILE)) {
    $handle = fopen(IP_DOMAINS_FILE, "r");
    while (($line = fgets($handle)) !== false) {
        $parts = explode('|', trim($line));
        if (isset($parts[0])) $ip_stats[$parts[0]] = ($ip_stats[$parts[0]] ?? 0) + 1;
    }
    fclose($handle);
}
arsort($ip_stats);
?>
<!DOCTYPE html>
<html lang="tr">
<head><meta charset="UTF-8"><title>Admin v3.5</title><link rel="stylesheet" href="../style.css">
<style>
    .tabs { display: flex; gap: 10px; margin-bottom: 20px; border-bottom: 2px solid var(--border); }
    .tab { padding: 10px 20px; text-decoration: none; color: var(--muted); background: var(--card); border-radius: 5px 5px 0 0; }
    .tab.active { background: var(--primary); color: white; }
    .stat-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; margin-bottom: 30px; }
    .stat-card { background: var(--card); padding: 20px; border-radius: 10px; border: 1px solid var(--border); text-align: center; }
    .stat-card h3 { font-size: 24px; color: var(--primary); }
    .ip-table { width: 100%; border-collapse: collapse; margin-top: 20px; }
    .ip-table th, .ip-table td { padding: 12px; border: 1px solid var(--border); text-align: left; }
    .ip-table th { background: var(--card); }
</style>
</head>
<body>
    <div class="admin-container">
        <div class="admin-header"><h1>⚙️ Yönetim Paneli v3.5</h1><p><a href="../index.php" class="btn">Ana Sayfa</a> <a href="?logout" class="btn btn-malicious">Çıkış</a></p></div>
        <?php if($_SESSION['success']){ echo "<div class='alert alert-success'>".$_SESSION['success']."</div>"; unset($_SESSION['success']); } ?>
        
        <div class="tabs">
            <a href="?tab=stats" class="tab <?php echo $active_tab == 'stats' ? 'active' : ''; ?>">📊 İstatistikler</a>
            <a href="?tab=ips" class="tab <?php echo $active_tab == 'ips' ? 'active' : ''; ?>">🌐 IP Yönetimi</a>
            <a href="?tab=malicious" class="tab <?php echo $active_tab == 'malicious' ? 'active' : ''; ?>">🚫 Zararlı</a>
            <a href="?tab=domains" class="tab <?php echo $active_tab == 'domains' ? 'active' : ''; ?>">📝 Domain Yükle</a>
            <a href="?tab=ads" class="tab <?php echo $active_tab == 'ads' ? 'active' : ''; ?>">📢 Reklamlar</a>
        </div>

        <?php if($active_tab == 'stats'): ?>
        <div class="admin-section">
            <h2>📊 Genel İstatistikler</h2>
            <div class="stat-grid">
                <div class="stat-card"><p>Toplam Domain</p><h3><?php echo number_format($stats['total_domains']); ?></h3></div>
                <div class="stat-card"><p>Toplam Oy</p><h3><?php echo number_format($stats['total_votes']); ?></h3></div>
                <div class="stat-card"><p>Toplam Yorum</p><h3><?php echo number_format($stats['total_comments']); ?></h3></div>
                <div class="stat-card"><p>Aktif IP Sayısı</p><h3><?php echo number_format($stats['unique_ips']); ?></h3></div>
            </div>
        </div>
        <?php endif; ?>

        <?php if($active_tab == 'ips'): ?>
        <div class="admin-section">
            <h2>🌐 IP Yönetimi ve Banlama</h2>
            <table class="ip-table">
                <thead><tr><th>IP Adresi</th><th>Eklenen Domain</th><th>Durum</th><th>İşlem</th></tr></thead>
                <tbody>
                    <?php foreach(array_slice($ip_stats, 0, 50) as $ip => $count): ?>
                    <tr>
                        <td><?php echo $ip; ?></td>
                        <td><?php echo $count; ?></td>
                        <td><?php echo in_array($ip, $banned_ips) ? '<span style="color:#ef4444;">Banlı</span>' : '<span style="color:#22c55e;">Aktif</span>'; ?></td>
                        <td>
                            <?php if(in_array($ip, $banned_ips)): ?>
                                <form method="post" style="display:inline;"><input type="hidden" name="ip" value="<?php echo $ip; ?>"><button type="submit" name="unban_ip" class="btn btn-small">Banı Kaldır</button></form>
                            <?php else: ?>
                                <form method="post" style="display:inline;"><input type="hidden" name="ip" value="<?php echo $ip; ?>"><button type="submit" name="ban_ip" class="btn btn-malicious btn-small">Banla</button></form>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php endif; ?>

        <?php if($active_tab == 'malicious'): ?>
        <div class="admin-section">
            <h2>🚫 Zararlı Siteler (<?php echo count($malicious_sites); ?>)</h2>
            <form method="post">
                <div style="margin-bottom: 15px;">
                    <button type="button" class="btn btn-primary" onclick="toggleAll(true)">Tümünü Seç</button>
                    <button type="button" class="btn" onclick="toggleAll(false)">Seçimi Kaldır</button>
                </div>
                <div class="checkbox-list">
                    <?php foreach($malicious_sites as $site): ?>
                    <div class="checkbox-item"><label><input type="checkbox" name="selected_malicious[]" value="<?php echo $site; ?>" class="malicious-check"> <?php echo $site; ?></label></div>
                    <?php endforeach; ?>
                </div>
                <button type="submit" name="delete_malicious_bulk" class="btn btn-malicious" style="margin-top:15px;">Seçilenleri Sil</button>
            </form>
            <script>function toggleAll(c){document.querySelectorAll('.malicious-check').forEach(e=>e.checked=c);}</script>
        </div>
        <?php endif; ?>

        <?php if($active_tab == 'domains'): ?>
        <div class="admin-section">
            <h2>📝 Domain Yükleme</h2>
            <div style="display:grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                <div>
                    <h3>Yerel Dosyadan Yükle (/urller/)</h3>
                    <form method="post">
                        <select name="local_file" style="width:100%; padding:10px; margin-bottom:10px; background:var(--card); color:var(--text); border:1px solid var(--border);">
                            <?php foreach($local_files as $file): ?><option value="<?php echo $file; ?>"><?php echo $file; ?></option><?php endforeach; ?>
                        </select>
                        <button type="submit" name="load_from_local" class="btn btn-primary">Dosyayı İşle</button>
                    </form>
                </div>
                <div>
                    <h3>Toplu Domain Ekle</h3>
                    <form method="post">
                        <textarea name="bulk_domains_admin" style="width:100%; height:100px; background:var(--bg); color:var(--text); border:1px solid var(--border); border-radius:8px; padding:10px;" placeholder="domain1.com&#10;domain2.com"></textarea>
                        <button type="submit" name="add_bulk_admin" class="btn btn-primary" style="width:100%; margin-top:10px;">Ekle</button>
                    </form>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <?php if($active_tab == 'ads'): ?>
        <div class="admin-section">
            <h2>📢 Reklam Yönetimi</h2>
            <form method="post">
                <textarea name="ad_codes" style="width:100%; height:300px; font-family:monospace; background:var(--bg); color:var(--text); border:1px solid var(--border); padding:10px;"><?php echo implode("---AD-SEPARATOR---", $ads); ?></textarea>
                <button type="submit" name="save_ads" class="btn btn-primary" style="margin-top:10px;">Reklamları Kaydet</button>
            </form>
        </div>
        <?php endif; ?>
    </div>
</body>
</html>
