<?php
// functions.php - v3.1 Stabil Temelli

function getClientIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) return $_SERVER['HTTP_CLIENT_IP'];
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    return $_SERVER['REMOTE_ADDR'];
}

function loadVotes() {
    if (!file_exists(VOTES_FILE)) return [];
    $votes = [];
    $handle = fopen(VOTES_FILE, "r");
    if ($handle) {
        while (($line = fgets($handle)) !== false) {
            $parts = explode('|', trim($line));
            if (count($parts) == 2) $votes[$parts[0]] = (int)$parts[1];
        }
        fclose($handle);
    }
    return $votes;
}

function saveVotes($votes) {
    $data = "";
    foreach ($votes as $domain => $count) $data .= "$domain|$count\n";
    file_put_contents(VOTES_FILE, $data);
}

function checkIPVote($ip, $domain) {
    if (!file_exists(IP_VOTES_FILE)) return false;
    $handle = fopen(IP_VOTES_FILE, "r");
    if ($handle) {
        while (($line = fgets($handle)) !== false) {
            $parts = explode('|', trim($line));
            if (count($parts) == 2 && $parts[0] == $ip && $parts[1] == $domain) {
                fclose($handle); return true;
            }
        }
        fclose($handle);
    }
    return false;
}

function recordIPVote($ip, $domain) {
    file_put_contents(IP_VOTES_FILE, "$ip|$domain\n", FILE_APPEND);
}

function loadMaliciousSites() {
    if (!file_exists(MALICIOUS_FILE)) return [];
    return file(MALICIOUS_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
}

function markAsMalicious($domain) {
    $domain = validateDomain($domain);
    if (!$domain) return false;
    $malicious = loadMaliciousSites();
    if (!in_array($domain, $malicious)) {
        file_put_contents(MALICIOUS_FILE, "$domain\n", FILE_APPEND);
    }
}

function deleteMaliciousSites($sites) {
    $current = loadMaliciousSites();
    $new = array_diff($current, $sites);
    file_put_contents(MALICIOUS_FILE, implode("\n", $new) . (empty($new) ? "" : "\n"));
    return count($sites);
}

function loadAds() {
    if (!file_exists(ADS_FILE)) return [];
    $content = file_get_contents(ADS_FILE);
    if (empty($content)) return [];
    return explode("---AD-SEPARATOR---", $content);
}

function saveAds($ads) {
    $content = implode("---AD-SEPARATOR---", $ads);
    file_put_contents(ADS_FILE, $content);
}

function isIPBanned($ip) {
    if (!file_exists(BANNED_IPS_FILE)) return false;
    $banned = file(BANNED_IPS_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    return in_array($ip, $banned);
}

function validateDomain($domain) {
    $domain = strtolower(trim($domain));
    $domain = preg_replace('/^https?:\/\//', '', $domain);
    $domain = preg_replace('/^www\./', '', $domain);
    if (strpos($domain, '/') !== false) return false;
    $domain = explode(':', $domain)[0];
    $domain = explode('?', $domain)[0];
    if (preg_match('/^[a-z0-9.-]+\.[a-z]{2,}$/', $domain)) return $domain;
    return false;
}

function saveUserSite($domain, $ip, $isAdmin = false) {
    $domain = validateDomain($domain);
    if (!$domain) return false;
    
    if (!$isAdmin) {
        $count = getIPDomainCount($ip);
        if ($count >= 1000) return false;
    }

    file_put_contents(USER_SITES_FILE, "$domain\n", FILE_APPEND);
    file_put_contents(IP_DOMAINS_FILE, "$ip|$domain\n", FILE_APPEND);
    return true;
}

function getIPDomainCount($ip) {
    if (!file_exists(IP_DOMAINS_FILE)) return 0;
    $count = 0;
    $handle = fopen(IP_DOMAINS_FILE, "r");
    if ($handle) {
        while (($line = fgets($handle)) !== false) {
            $parts = explode('|', trim($line));
            if (count($parts) > 0 && $parts[0] == $ip) $count++;
        }
        fclose($handle);
    }
    return $count;
}

function processLargeFile($filePath, $ip = null, $isAdmin = false) {
    if (!file_exists($filePath)) return ['added' => 0];
    $handle = fopen($filePath, "r");
    $added = 0;
    $buffer = "";
    $ip_buffer = "";
    if ($handle) {
        while (($line = fgets($handle)) !== false) {
            $domain = validateDomain($line);
            if ($domain) {
                $buffer .= "$domain\n";
                if ($ip) $ip_buffer .= "$ip|$domain\n";
                $added++;
                if ($added % 1000 == 0) {
                    file_put_contents(USER_SITES_FILE, $buffer, FILE_APPEND);
                    if ($ip) file_put_contents(IP_DOMAINS_FILE, $ip_buffer, FILE_APPEND);
                    $buffer = ""; $ip_buffer = "";
                }
            }
        }
        if (!empty($buffer)) file_put_contents(USER_SITES_FILE, $buffer, FILE_APPEND);
        if (!empty($ip_buffer)) file_put_contents(IP_DOMAINS_FILE, $ip_buffer, FILE_APPEND);
        fclose($handle);
    }
    return ['added' => $added];
}
?>
